/*
  
Macro Scripts File
Created:  24 mai 2003
Version:  3ds MAX 6
Author:   PF Breton

Macro Scripts that fires some Utilities
Purpose: Hooking up some of them from the Main menu

Revision History:
   24 mai 2003, initial implementation for 3ds max 6, pfbreton

   4 dec 2003, adding File Link Manager launcher for 3ds max 6 and  File Link Extension, pfbreton

	17 dec 2003, Pierre-Felix Breton, 
		added File Link Manager Launcher
		added Substitute Manager Launcher

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products
		
	17 march 2006, Pierre-Felix Breton
		added Publish to DWF command

Macro Scripts that fires some Utilities
Purpose: Hooking up some of them from the Main menu

*/
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

MacroScript Panoramic_Exporter
ButtonText:~PANORAMIC_EXPORTER_BUTTONTEXT~
category:~PANORAMIC_EXPORTER_CATEGORY~ 
internalCategory:"Render" 
Tooltip:~PANORAMIC_EXPORTER_TOOLTIP~ 
(
	try(
            max utility mode
	    utilitypanel.openutility Panorama_Exporter
		) catch()
)


MacroScript Color_Clip_Board
ButtonText:~COLOR_CLIP_BOARD_BUTTONTEXT~
category:~COLOR_CLIP_BOARD_CATEGORY~ 
internalCategory:"Tools" 
Tooltip:~COLOR_CLIP_BOARD_TOOLTIP~ 
(
	try (utilitypanel.openutility Color_Clipboard) catch()
)

MacroScript Assign_Vertex_Colors
ButtonText:~ASSIGN_VERTEX_COLORS_BUTTONTEXT~
category:~ASSIGN_VERTEX_COLORS_CATEGORY~ 
internalCategory:"Tools" 
Tooltip:~ASSIGN_VERTEX_COLORS_TOOLTIP~ 
(
	try (utilitypanel.openutility Assign_Vertex_Colors) catch()
)


MacroScript Perspective_Match
ButtonText:~PERSPECTIVE_MATCH_BUTTONTEXT~
category:~PERSPECTIVE_MATCH_CATEGORY~ 
internalCategory:"Tools" 
Tooltip:~PERSPECTIVE_MATCH_TOOLTIP~ 
(
	try (utilitypanel.openutility Perspective_Match) catch()
)


MacroScript Resource_Collector
ButtonText:~RESOURCE_COLLECTOR_BUTTONTEXT~
category:~RESOURCE_COLLECTOR_CATEGORY~ 
internalCategory:"File" 
Tooltip:~RESOURCE_COLLECTOR_TOOLTIP~ 
(
	try(
		max utility mode
		utilitypanel.openutility Resource_Collector
	) catch()
)

MacroScript Map_Path_Editor
ButtonText:~MAP_PATH_EDITOR_BUTTONTEXT~
category:~MAP_PATH_EDITOR_CATEGORY~ 
internalCategory:"File" 
Tooltip:~MAP_PATH_EDITOR_TOOLTIP~ 
(
	try(
		max utility mode
		utilitypanel.openutility Bitmap_Photometric_Paths
	) catch()
)


MacroScript Channel_Info
ButtonText:~CHANNEL_INFO_BUTTONTEXT~
category:~CHANNEL_INFO_CATEGORY~ 
internalCategory:"Tools" 
Tooltip:~CHANNEL_INFO_TOOLTIP~ 
(
	on execute do	(
		try(
			channelInfo.Dialog ()
		) catch()
	)
	on closeDialogs do (
		try (
			channelInfo.closeDialog()
		) catch ()
	)
	on isChecked return (
		try (
			channelInfo.IsChecked ()
		) catch ( false )
	)
)

MacroScript Launch_VMS
ButtonText:~LAUNCH_VMS_BUTTONTEXT~
Category:~LAUNCH_VMS_CATEGORY~ 
internalCategory:"MAX Script" 
Tooltip:~LAUNCH_VMS_TOOLTIP~ 
(
 vms = visualMS.CreateForm()
 vms.Open()
)

MacroScript Publish_To_DWF
ButtonText:~PUBLISH_TO_DWF_BUTTONTEXT~
category:~PUBLISH_TO_DWF_CATEGORY~ 
internalCategory:"File" 
Tooltip:~PUBLISH_TO_DWF_TOOLTIP~ 
(
		--------------------------------
		--Browse for file dialog
		--------------------------------
		 
		local strMyFile= ""
		strMyFile = getSaveFileName caption:~GETSAVEFILENAME_CAPTION~ \ --LOC NOtes: Localize this
							filename:((getdir #export) + "\\" + (getFilenameFile maxfilename) + ".dwf") \
							types:~DESIGN_WEB_FORMAT_TYPES_CAPTION~
		
		-- user canceled?			
		if (strMyFile!= undefined) then  					
		(
			exportFile strMyFile using:DWF_Exporter	
		)--end if
	
)--en publish to DWF


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAsv/xt/HJ8I1V72Sh2D10q3sNJ6Rl4+vge
-- ORJLRFybz8M7dCPvSfoXjsML9KRq3q3mLOI4uSkgEWf06ymPS6PjRtD1dIN7p2By
-- Nn0uHxFVKwYBYA2pbLdHxAEkoNRby3/zph0Z/ymoinZYWgVZ9QFk1nCHTgK5sUiM
-- /hpv90BpWJ59lu5NH2/D9vQ21c9N0D5O2TnBcE3oZoyYjfb2jdr/El3t7TlZMm+H
-- Kxj5TeKX1eF1tXDZkE2W9fKkxYLQoCM99d0Fj3JwGYbch5hsWgoi3DiIx8YtLrDG
-- nf7ukUxKNRxLZXPWpugsuDtBXGPsCOdMEwPBx2uBggWxvH3OLKTq
-- -----END-SIGNATURE-----